﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Inet.Viewer.Data
{
    /// <summary>
    /// An implementation of IPageReceiver which forwards any error during page receiving to 
    /// a delegate. Actual page data is ignored.
    /// </summary>
    internal class FailurePageReceiver : IPageReceiver
    {
        private Action<Exception> action;

        /// <summary>
        /// Creates the instance with the specified delegate.
        /// </summary>
        /// <param name="action">the delegate which receives errors</param>
        internal FailurePageReceiver(Action<Exception> action)
        {
            this.action = action;
        }

        /// <inheritdoc/>
        public bool WriteReportInfo(Data.ReportInfo info, Data.PageLoader loader)
        {
            return true;
        }

        /// <inheritdoc/>
        public bool WritePageInfo(Data.PageInfo info, Data.PageLoader loader)
        {
            return true;
        }

        /// <inheritdoc/>
        public System.Drawing.Font GetEmbeddedFont(int fontID, int fontRevision)
        {
            return null;
        }

        /// <inheritdoc/>
        public void PageLoadFailure(Exception exception)
        {
            action(exception);
        }
    }
}
